# coding: utf-8

import datetime

from gm_types.push import PUSH_INFO_TYPE

from api.tasks.push_task import allocate_push_task_one
from rpc.tool.protocol import PushUrlProtocol, gm_protocol


def share_push(user_id, msg):
    """
    用于11,11 大促的推送
    :param user_id:
    :return:
    """
    kwargs = {
        'extra': {
            'type': PUSH_INFO_TYPE.GM_PROTOCOL,
            'pushUrl': gm_protocol.point_detail,
            'push_url': gm_protocol.point_detail,
        },
        'platform': ['android', 'iPhone'],
        'user_id': user_id,
        'alert': msg
    }
    allocate_push_task_one(**kwargs)


class NotifyManager(object):
    @classmethod
    def send_push(cls, user_id, alert="", platform=None, extra=None, labels=None):
        """
        Push通知
        :param user_id:
        :param alert:
        :param platform:
        :param extra:
        :return:
        """
        if not platform:
            platform = ['android', 'iPhone']
        allocate_push_task_one(user_id=user_id, platform=platform, extra=extra, alert=alert, labels=labels)

    @classmethod
    def send_message(cls, phone, template_id, params, platform=None):
        """
        短信通知
        :return:
        """
        pass

    @classmethod
    def send_notification(cls):
        """
        站内消息
        :return:
        """
        pass
