# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function
from rpc.cache import sku_stock_lock
from rpc.tool.error_code import CODES, gen


lock_sku_stock_key_tpl = "sku_lock_{0}"


def unlock_sku_stock(price_id):
    """
    解除锁定
    :param price_id:
    :return:
    """
    key = lock_sku_stock_key_tpl.format(price_id)
    sku_stock_lock.delete(key)


def lock_sku_stock(price_id):
    """
    库存锁定
    :param price_id:
    :return:
    """
    key = lock_sku_stock_key_tpl.format(price_id)
    if sku_stock_lock.get(key):
        gen(CODES.UNIVERSAL)

    sku_stock_lock.set(key, 1, 1 * 60 * 60)
