# -*- coding:utf-8 -*-

'''
助力操作
'''

from gm_types.error import ERROR as ERROR_CODES

from rpc.decorators import bind_context, bind
from rpc.tool.error_code import gen
from api.tool.user_tool import get_user_from_context
from api.models import AssistPrize, AssistCode, Assister, AssistThirdInfo
from util import get_code_detail, _do_assist


@bind_context('account/assist/get_acode', login_required=True)
def get_acode(ctx, pid):
    '''
    获取助力码
    '''

    user = get_user_from_context(ctx)
    user_id = user.id
    _res, _rea = AssistCode.get_new_acode_for_pid(user_id, pid)
    if not _res:
        return gen(_rea)

    obj = _rea
    return get_code_detail(obj)


@bind_context('account/assist/do_assist', login_required=True)
def do_assist(ctx, uid, acode):
    '''
    助力操作
    param uid: user_id
    param acode: assist_code
    param wechat_info: 微信信息
    '''
    user = get_user_from_context(ctx)
    user_id = user.id
    return _do_assist(user_id, acode)


@bind_context('account/assist/address_trig')
def trigger_address(ctx, a_code):
    '''
    用户助力成功后, 记录地址
    '''
    user = get_user_from_context(ctx)
    user_id = user and user.id
    if user_id and a_code:
        AssistCode.update_receive_status(user_id, a_code)

