from talos.backbone.rpc import bind

from api.view.service import get_service_card_info_by_ids
from api.view.hospital import get_hospital_card_info_by_ids
from api.view.ranklist import get_randboard_card_by_ids
from api.view.doctor import get_doctor_card_info_by_ids

# TODO: move all the "get_XXX_info_by_ids" to here
from api.models import Tag
def get_service_list_by_ids(str_ids_list):
    result = []
    for list_ids in str_ids_list:
        ids = list_ids.split(',')
        value_queryset = Tag.objects.filter(id__in=ids).values('id','name')
        result.append(
            {
                'id': list_ids,
                'data': list(value_queryset)
             }
        )
    return result

@bind('api/get_cards_info')
def cards_info(data_list):

    if not len(data_list):
        return {}

    result = {}
    card_type2_func = {
        'service': get_service_card_info_by_ids,
        'hospital': get_hospital_card_info_by_ids,
        'doctor': get_doctor_card_info_by_ids,
        'rankboard': get_randboard_card_by_ids,
        'service_list': get_service_list_by_ids,
    }
    for d in data_list:
        card_type = d['card_type']
        id_list = d['id_list']
        if card_type in ['service', 'hospital', 'doctor', 'rankboard', 'service_list']:
            result.update({
                card_type: card_type2_func[card_type](id_list)
            })
        else:
            # no card_type to handle
            continue
    return result




