# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function
from rpc.decorators import bind

from api.models.slide import HomepageOperate
from gm_types.gaia import HOMEPAGE_OPERATE_LOCATION
from gm_types.gaia import HOT_SEARCH_JUMP_TYPE
from rpc.decorators import cache_page


@bind('api/diary/jump_operate')
def diary_jump_operate(location=19):

    jump_operate = HomepageOperate.objects.filter(location=location, is_online=True).order_by('-last_time').first()
    if not jump_operate:
        return {}

    return {
        'jump': jump_operate.jump,
        'jump_type': jump_operate.jump_type,
        'title': jump_operate.title,
    }


@bind('api/diary/service_type')
@cache_page(60 * 5)
def get_diary_service_type(diary_id):
    _locations = [HOMEPAGE_OPERATE_LOCATION.ADV_DIARY_1,
                  HOMEPAGE_OPERATE_LOCATION.ADV_DIARY_2,
                  HOMEPAGE_OPERATE_LOCATION.ADV_DIARY_3,
                  HOMEPAGE_OPERATE_LOCATION.ADV_DIARY_4]
    _jum_type = HOT_SEARCH_JUMP_TYPE.DIARY[0]
    _data = HomepageOperate.objects.filter(location__in=_locations,
                                           jump_type=_jum_type,
                                           jump=diary_id,
                                           is_online=True).order_by('-last_time').first()
    if _data:
        return {
            'business_type': _data.service_type,
            'ordering': _data.location
        }
    return None

@bind('api/diary/service_type_list')
def get_diary_service_types(diary_ids):
    _locations = [HOMEPAGE_OPERATE_LOCATION.ADV_DIARY_1,
                  HOMEPAGE_OPERATE_LOCATION.ADV_DIARY_2,
                  HOMEPAGE_OPERATE_LOCATION.ADV_DIARY_3,
                  HOMEPAGE_OPERATE_LOCATION.ADV_DIARY_4]
    _jum_type = HOT_SEARCH_JUMP_TYPE.DIARY[0]
    _data = HomepageOperate.objects.filter(location__in=_locations,
                                           jump_type=_jum_type,
                                           jump__in=diary_ids,
                                           is_online=True)
    _list_types = list()
    for _item in _data:
        _list_types.append({
            'diary_id': _item.jump,
            'business_type': _item.service_type,
            'ordering': _item.location
        })

    return _list_types