# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

from api.models import Order
from rpc.tool.error_code import gen, CODES
from rpc.decorators import bind


@bind('api/gx/callback')
def gx_callback(app_id, order_id):
    try:
        order = Order.objects.get(pk=order_id)
        order.stage_app_id = app_id
        order.save()
    except Order.DoesNotExist:
        gen(CODES.ORDER_NOT_FOUND)
