# coding=utf-8
import time
import datetime

from gm_types.gaia import BASE_BAR_CONFIG
from api.services.icon_service import IconService
from rpc.decorators import bind
from api.models.icon import ServiceJumpConfig, IndexDefaultBar


@bind('api/user_center/icon')
def get_icons():
    """
    获取我的页面icon配置
    :return:
    """
    return IconService.get_icon_list()


@bind("api/get/default_bar")
def get_default_bar():
    default_bar = IndexDefaultBar.objects.filter(is_online=True, start_time__lte=datetime.datetime.now(),
                                                 end_time__gte=datetime.datetime.now()).first()
    return {"default_bar": default_bar.bar_type if default_bar else BASE_BAR_CONFIG.INDEX}


@bind("api/get/service_default_jump")
def get_service_default_jump():
    config_info = ServiceJumpConfig.objects.filter(is_online=True, start_time__lte=datetime.datetime.now(),
                                                   end_time__gte=datetime.datetime.now()).first()

    data = {"url": config_info.url, "name": config_info.name, "end_time": time.mktime(config_info.end_time.timetuple())} if config_info else {}
    return {"default_service_info": data}
