# -*- coding: utf-8 -*-
# @Time    : 2019/4/10

from rpc.decorators import bind, bind_context
from ..models import CategoryPolymer
from api.tool.geo_tool import get_city_by_options
from api.tool.city_tool import get_city_id_by_options


@bind_context('api/category/polymer')
def get_category_polymer(ctx, category_polymer_id, city_id=None, lat=None, lng=None):
    """
    品类聚合页
    :param category_polymer_id:
    :return:
    """
    city_id = get_city_id_by_options(city_id, lat, lng)

    cp = CategoryPolymer.objects.get(id=category_polymer_id)
    slides = cp.get_banners(city_id)
    category_area = cp.get_areas()
    brands = cp.get_brands()
    groups = cp.get_groups()
    static_templates = cp.get_gadgets()
    return {
        'slides': slides,
        'category_area': category_area,
        'brands': brands,
        'groups': groups,
        'static_templates': static_templates,
        'search_word': cp.search_word,
        'id': cp.id,
        'name': cp.name,
        'tags': CategoryPolymer.get_tags(category_polymer_id)
    }


@bind('api/category/polymer_recommend')
def get_ctg_plm_recommend(cp_id, city_id=None, lat=None, lng=None):
    '''
    获取品类聚合页运营推荐位及tags_id
    '''
    city_id = get_city_id_by_options(city_id, lat, lng)

    recommends = CategoryPolymer.get_recommend(cp_id, city_id) or {}
    tags = CategoryPolymer.get_tags(cp_id)
    result = {}
    result['recommends'] = recommends
    result['tags'] = tags
    return result
