# -*- coding: UTF-8 -*-

from django.db import models
from . import Channel


class Version(models.Model):
    class Meta:
        verbose_name = '版本号'
        app_label = 'channel'
    version = models.CharField(verbose_name=u'版本号', max_length=20, unique=True)
    packed_channel = models.ManyToManyField(Channel, verbose_name=u'已打包渠道',
                                            through='VersionToChannel', related_name='versions')
    release_time = models.DateTimeField(verbose_name=u'上传时间', null=True, blank=True, auto_now_add=True)
    md5 = models.CharField(verbose_name=u'MD5', max_length=100)
    description = models.TextField(verbose_name=u'版本说明', null=True, blank=True)
    is_released = models.BooleanField(verbose_name=u'是否已发布', default=False)
    is_confirm = models.BooleanField(verbose_name=u'是否收到确认发版的邮件', default=False)


class VersionToChannel(models.Model):
    class Meta:
        verbose_name = 'ManyToMany Relationship'
        app_label = 'channel'
    version = models.ForeignKey(Version, verbose_name=u'版本')
    channel = models.ForeignKey(Channel, verbose_name=u'渠道')
    packed = models.BooleanField(verbose_name=u'是否已打包', default=False)
    packed_time = models.DateTimeField(verbose_name=u'打包时间', null=True, blank=True)
    release_time = models.DateTimeField(verbose_name=u'发布时间', null=True, blank=True)
    is_released = models.BooleanField(verbose_name=u'是否已发布', default=False)
