from django.shortcuts import render, redirect, HttpResponse
from doclib.api_info import api_info
import json


def render_json(output_object):
    output_data = json.dumps(output_object, sort_keys=True, indent=4, ensure_ascii=False, encoding='utf8')
    res = HttpResponse(content=output_data, content_type='application/json; charset=utf-8')
    return res


def index(request):
    return redirect(method_list)


def method_list(request):
    mlist = api_info.get_method_list()
    mlist = sorted(mlist)
    result = {
        'data': {
            'method_list': mlist,
        }
    }
    return render(request, 'method-list.jinja.html', result)


def method_info(request):
    name = request.GET['name']
    info = api_info.get_method_document(name)
    return render_json(info)
