# -*- coding: utf-8 -*-

from django.db import models

from gm_upload import IMG_TYPE, ImgUrlField
from gm_types.gaia import HOSPITAL_TYPE

# TODO Skyler 迁移
from hippo.models.register import (
    DoctorRegister, RegisterOrganization, DoctorRegisterAgreement,
    DoctorRegisterLicence, DoctorRegisterAgreement, DoctorRegisterRecord,
)

# TODO Skyler 待废弃 HospitalCapture DoctorCapture ItemsCapture
class HospitalCapture(models.Model):
    class Meta:
        verbose_name = u'医院（采集）'
        verbose_name_plural = u'医院（采集）'

    url_id = models.IntegerField(verbose_name=u'医院ID', primary_key=True)
    uuid = models.CharField(u'唯一标志', unique=True, max_length=100, null=True)
    url = models.CharField(verbose_name=u'URL', max_length=100, default='')
    name = models.CharField(verbose_name=u'医院名', max_length=100)
    address = models.CharField(verbose_name=u'地址', max_length=100, null=True, blank=True, default='')
    specialty = models.CharField(verbose_name=u'specialty', max_length=20)
    description = models.TextField(verbose_name=u'描述', max_length=4096)
    album_url = models.CharField(verbose_name=u'相册地址', max_length=256)
    contacts = models.TextField(verbose_name=u'联系方式', max_length=1024)
    tel = models.CharField(verbose_name=u'联系电话', max_length=20, null=True, blank=True)
    main_pic_url = ImgUrlField(img_type=IMG_TYPE.HOSPITALCAPTURE, verbose_name=u'主要图片', max_length=256)
    hospital_type = models.CharField(max_length=1, verbose_name=u'医院类型', null=False,
                                     default=HOSPITAL_TYPE.PRIVATE, choices=HOSPITAL_TYPE)
    info_verified = models.BooleanField(verbose_name=u'信息已核实', default=False)
    is_handled = models.BooleanField(verbose_name=u'是否已经处理', default=False)
    comments = models.TextField(max_length=200, null=True, blank=True, default='', verbose_name=u'备注')

    def __unicode__(self):
        return self.name


class DoctorCapture(models.Model):
    class Meta:
        verbose_name = u'医生（采集）'
        verbose_name_plural = u'医生（采集）'

    def __unicode__(self):
        return self.name

    doctor_url_id = models.IntegerField(verbose_name=u'ID', primary_key=True)
    name = models.CharField(verbose_name=u'医生名', max_length=100)
    url = models.CharField(verbose_name=u'URL', max_length=100, default='')
    hospital = models.ForeignKey(HospitalCapture, null=True)
    description = models.TextField(verbose_name=u'描述', max_length=4096, null=True, blank=True)
    album_url = models.CharField(verbose_name=u'相册地址', max_length=256)
    info_verified = models.BooleanField(verbose_name=u'信息已核实', default=False)
    is_handled = models.BooleanField(verbose_name=u'是否已经处理', default=False)
    comments = models.CharField(max_length=200, null=True, blank=True, default='', verbose_name=u'备注')


class ItemsCapture(models.Model):
    class Meta:
        verbose_name = u'项目（采集）'
        verbose_name_plural = u'项目（采集）'

    item_name = models.CharField(u'项目名称', max_length=30)
    slogan = models.CharField(u'项目描述', max_length=80)
    level_attention = models.CharField(u'关注度', max_length=20)
    level_safety = models.CharField(u'安全度', max_length=20)
    level_complex = models.CharField(u'复杂度', max_length=20)
    treatment_means = models.CharField(u'治疗手段', max_length=100)
    effect_continue = models.CharField(u'效果持续', max_length=100, null=True)
    recovery_time = models.CharField(u'恢复时间', max_length=200)
    advantage = models.TextField(u'优点')
    disadvantage = models.TextField(u'缺点')
    side_effect = models.TextField(u'副作用及风险')
    item_sub_item = models.CharField(u'一级分类-二级分类-项目名称', max_length=50)
    treatment_method = models.TextField(u'治疗方法')
    treatment_effect = models.TextField(u'治疗效果')
    notes = models.TextField(u'注意事项')
    fit_people = models.TextField(u'适合人群')
    treatment_length = models.CharField(u'治疗时长', max_length=100)
    anesthesia_method = models.CharField(u'麻醉方法', max_length=100)
    hospital_treatment = models.CharField(u'住院治疗', max_length=100)
    line_days = models.CharField(u'拆线天数', max_length=100, null=True)
    treat_num = models.CharField(u'治疗次数', max_length=100)
    recovery_process = models.CharField(u'恢复过程', max_length=100, null=True)

    def __unicode__(self):
        return self.item_name
