#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/1/11

from django.db import models
from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import NEW_SPRING_ACTIVITY_IMA_LEVEL
from api.models.user import User


class ActivityConfig(models.Model):
    class Meta:
        verbose_name = u'新春活动后台配置'
        db_table = 'facialactivity_activity_config'
        app_label = 'facialactivity'
        unique_together = ("level", "tag")

    level = models.CharField(max_length=10, verbose_name=u'等级')
    tag = models.CharField(max_length=10, verbose_name=u'等级对应的标签')
    threshold = models.IntegerField(verbose_name=u'阈值', default=0)
    create_time = models.DateTimeField(u'创建时间', auto_now=True)


class ActivityUserImage(models.Model):
    class Meta:
        verbose_name = u'新春活动用户信息'
        db_table = 'facialactivity_user_image'
        app_label = 'facialactivity'

    user = models.ForeignKey(User, verbose_name=u'用户')
    click_nums = models.IntegerField(u'点击数', default=0)
    image_url = ImgUrlField(u'上传图片', img_type=IMG_TYPE.CAMPAIGNIMAGELINK, max_length=200, default='', unique=True)
    level = models.IntegerField(default=NEW_SPRING_ACTIVITY_IMA_LEVEL.ACTIVITY_LEVEL_SEVEN, verbose_name=u'图片等级')
    form_id = models.CharField(verbose_name=u'推送消息form_id, 有效期7天', max_length=256)
    fake_exceed_nums = models.IntegerField(verbose_name=u'虚拟马甲数', default=0)
    real_click_nums = models.IntegerField(verbose_name=u'真实点击数', default=0)
    create_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(u'更新时间', auto_now=True)
    is_online = models.BooleanField(u'是否上线', default=True)
    is_deleted = models.BooleanField(u'是否删除', default=False)
    is_vest = models.BooleanField(u'是否马甲', default=False)
    is_push = models.BooleanField(u'是否推送', default=False)
    is_click = models.BooleanField(u'是否点击', default=False)
    is_share = models.BooleanField(u'是否分享', default=False)

