#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/1/15

from rpc.cache import new_spring_click
from rpc.tool.error_code import CODES, gen

lock_user_key_tpl = "newspring_activity_code_{0}"


def lock_user_newspring(activity_image_id):
    """
        锁定活动图片ID，防止重复
    """

    key = lock_user_key_tpl.format(activity_image_id)
    if new_spring_click.get(key):
        gen(CODES.LIVE_LIKE_TIME_LIMIT)

    new_spring_click.set(key, 1, 1 * 30)


def unlock_user_newspring(activity_image_id):

    key = lock_user_key_tpl.format(activity_image_id)
    new_spring_click.delete(key)