# coding=utf-8

from base import *

SECRET_KEY = '__PLACEHOLDER__'

DEBUG = False

ALLOWED_HOSTS = []


DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': ':memory:',
    }
}

# Redis
REDIS = {
    'diary': {},
    'doctor': {},
    'hospital': {},
    'view': {},
    'tag_cache': {},
    'user_cache': {},
    'page_cache': {},
}


TEMPLATES = []

USE_DOC = DEBUG

# document for ``doc'' app
if USE_DOC:
    INSTALLED_APPS += (
        'doc',
    )

    TEMPLATES += [
        {
            'BACKEND': 'django.template.backends.jinja2.Jinja2',
            'APP_DIRS': True,
        },
    ]

USER_JPUSH_APP_KEY = ''
USER_JPUSH_MASTER_SECRET = ''
DOCTOR_JPUSH_APP_KEY = ''
DOCTOR_JPUSH_MASTER_SECRET = ''

IPHONE_USE_SANDBOX = ''
IPHONE_LIVE_APN_PUSH_CERT = ''

ES_HOSTS = [{}]
ES_INDEX = 'doc_es_index'

ASYNC_QUEUE = {
    'redis_url': '',
    'redis_prefix': 'doc:gaia:async-queue',
    'logger_name': 'async_queue',
    'check_period_seconds': 10,
}

DATA_SYNC = {
    'redis_url': '',
    'prefix': 'doc:gaia:data-sync',
    'enqueue_table_event': False,
}

