# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import graphene
from graphene_django import DjangoObjectType

from api.models import Hospital

from gm_types.doctor import HOSPITAL_LEVEL


class HospitalType(DjangoObjectType):

    class Meta:
        model = Hospital

    hospital_type = graphene.Field(graphene.String)
    hospital_level = graphene.Field(graphene.Int)

    def resolve_hospital_level(self, *args, **kwargs):
        if hasattr(self, "hospital_extra"):
            return self.hospital_extra.hospital_level
        else:
            return HOSPITAL_LEVEL.NONE
