# coding=utf-8

import tablib
from django.core.management import BaseCommand
from api.models import Diary


class Command(BaseCommand):
    """
    python manage.py dump_20170109_export_diary_rating
    导出医院信息
    """

    def handle(self, *args, **options):
        diarys = Diary.objects.all()
        dt_result = tablib.Dataset()
        dt_result.headers = [
            u'日记本ID', u'关联的医生ID', u'关联的订单号', u'术后效果评分', u'服务态度评分',u'就医环境评分'
        ]

        for diary in diarys:
            try:
                x = (
                    diary.id,
                    diary.doctor_id,
                    diary.order_id,
                    diary.operation_effect_rating,
                    diary.doctor_attitude_rating,
                    diary.hospital_env_rating
                )
                dt_result.append(x)
                print diary.id
            except Exception as e:
                print e.message
                continue
        open('diary_info.xlsx', 'wb').write(dt_result.xlsx)
