# coding=utf-8
# create by oldman at 17/1/11
import datetime
import tablib
from django.core.management import BaseCommand
from gm_types.gaia import SERVICE_REVIEW_STATUS

from api.models import ServiceReviewRecord, Service

PROVINCE_BUSINESS = {
    'chongqing': u'西南',
    'yunnan': u'西南',
    'xinjiang': u'西南',
    'sichuan': u'西南',
    'shanxi': u'西南',
    'qinghai': u'西南',
    'ningxia': u'西南',
    'henan': u'西南',
    'guizhou': u'西南',
    'gansu': u'西南',
    'xizang': u'西南',

    'jiangxi': u'华中',
    'hunan': u'华中',
    'hubei': u'华中',
    'guangxi': u'华中',

    'hainan': u'华南',
    'guangdong': u'华南',
    'fujian': u'华南',

    'zhejiang': u'华东',
    'shanghai': u'华东',
    'jiangsu': u'华东',
    'anhui': u'华东',

    'tianjin': u'华北',
    'shannxi': u'华北',
    'shandong': u'华北',
    'neimenggu': u'华北',
    'liaoning': u'华北',
    'jilin': u'华北',
    'heilongjiang': u'华北',
    'beijing': u'华北',
    'hebei': u'华北',

    'xianggang': u'海外',
    'taiwan': u'海外',
    'shouer': u'海外',
    'mangu': u'海外',
    'jizhoutebiezizhidao': u'海外',
    'dongjing': u'海外',
    'aomen': u'海外',
}


class Command(BaseCommand):
    """
    导出有问题的美购
    python manage.py dump_20170111_export_service_dump
    create by oldman 2017-01-11
    """

    def handle(self, *args, **options):
        start_date = datetime.date(day=11, month=11, year=2016)
        end_date = datetime.date(day=11, month=1, year=2017)
        records = ServiceReviewRecord.objects.filter(
            audit_time__range=[start_date, end_date],
            now_review_status__in=[
                SERVICE_REVIEW_STATUS.TURN_DOWN,
                SERVICE_REVIEW_STATUS.PASS,
                SERVICE_REVIEW_STATUS.SPECIAL_APPROVAL_TURN_DOWN
            ],
        ).values("serviceregister__service_id").distinct()
        headers = [
            u'美购id', u'美购名称', u'是否在线', u'关联tag', u'医生',
            u'医院', u'商务', u'大区', u'驳回次数', u'通过次数',
        ]
        data = tablib.Dataset(headers=headers)
        for record in records:
            service_id = record['serviceregister__service_id']
            try:
                service = Service.objects.get(id=service_id)
            except Service.DoesNotExist:
                print("error service id {}".format(service_id))
                continue
            origin_records = ServiceReviewRecord.objects.filter(
                audit_time__range=[start_date, end_date],
                serviceregister__service_id=service,
            )
            data_set = [
                service.id,
                service.name,
                u'是' if service.is_online else u'否',
                u",".join([tag.name for tag in service.tags.all()]),
                service.doctor.name,
                service.doctor.hospital.name,
                service.doctor.business_partener.username if service.doctor.business_partener else u"",
                PROVINCE_BUSINESS.get(service.doctor.hospital.city.province_id, u""),
                origin_records.filter(now_review_status__in=[
                    SERVICE_REVIEW_STATUS.TURN_DOWN,
                    SERVICE_REVIEW_STATUS.SPECIAL_APPROVAL_TURN_DOWN
                ]).count(),
                origin_records.filter(now_review_status=SERVICE_REVIEW_STATUS.PASS).count(),
            ]
            data.append(data_set)
            print(data_set)
        open(u'/data/service/service_problem.xlsx', 'wb').write(data.xlsx)
        print ("is done")
