# coding=utf-8
# create by oldman at 17/3/8
import tablib
from django.core.management import BaseCommand

from api.models import DoctorRegisterInfo
from doctor.models import DoctorRegister


class Command(BaseCommand):
    """
    python manage.py dump_20170308_export_doctor_register
    导出医生的注册申请数据
    """

    def handle(self, *args, **options):
        dt_result_doctor_register = tablib.Dataset()
        dt_result_doctor_register.headers = [u'ID', u'真实姓名', u'登录手机号', u'联系手机号', u'现工作医院', u'关联商务',
                                             u'注册时间', u'是否已处理', u'备注']
        doctor_registers = DoctorRegister.objects.filter().all()
        for doctor_register in doctor_registers:
            try:
                print doctor_register.id
                x = (
                    doctor_register.id,
                    doctor_register.name,
                    doctor_register.person.phone if doctor_register.person else '',
                    doctor_register.phone,
                    doctor_register.hospital,
                    doctor_register.business_partener.last_name if doctor_register.business_partener else '',
                    doctor_register.add_time,
                    doctor_register.is_handled,
                    doctor_register.comments

                )
                dt_result_doctor_register.append(x)
            except Exception as e:
                print e.message
                continue


        open('/data/service/doctorregister.xlsx', 'wb').write(dt_result_doctor_register.xlsx)
        open('/data/service/doctorregister.csv', 'wb').write(dt_result_doctor_register.xlsx)

        print u'医生申请done'

        dt_result_doctor_register_info = tablib.Dataset()
        dt_result_doctor_register_info.headers = [u'ID', u'医生名字', u'联系方式', u'邮箱', u'医院', u'申请时间',
                                                  u'是否已处理', u'备注']
        doctor_registerinfos = DoctorRegisterInfo.objects.filter().all()
        for doctor_registerinfo in doctor_registerinfos:
            try:
                print doctor_registerinfo.id
                x = (
                    doctor_registerinfo.id,
                    doctor_registerinfo.name,
                    doctor_registerinfo.phone,
                    doctor_registerinfo.hospital,
                    doctor_registerinfo.email,
                    doctor_registerinfo.created_time,
                    doctor_registerinfo.is_handled,
                    doctor_registerinfo.comments

                )
                dt_result_doctor_register_info.append(x)
            except Exception as e:
                print e.message
                continue
        open('/data/service/doctorregisterinfo.xlsx', 'wb').write(dt_result_doctor_register_info.xlsx)
        open('/data/service/doctorregisterinfo.csv', 'wb').write(dt_result_doctor_register_info.xlsx)
        print u'医生注册申请done'
