# coding=utf-8

import tablib
import xlrd
from django.conf import settings
from django.core.management import BaseCommand
from gm_types.gaia import TRANS_ACTION, TRANS_STATUS
from rpc.tool.queryset_tool import big_qs_iter
from cashback.models import TransactionLog


class Command(BaseCommand):
    """
    驳回嫌疑用户提现申请
    """

    def handle(self, *args, **options):

        all_users = TransactionLog.objects.filter(type=TRANS_ACTION.WITHDRAW, state=TRANS_STATUS.WAIT)
        reject_users = all_users.exclude(user_id__in=normal_user_ids)
        dt_result = tablib.Dataset()
        dt_result.headers = [
            u'id', u'用户id', u'用户名', u'提现金额', u'当前状态'
        ]
        for reject_user in big_qs_iter(reject_users):
            try:
                x = (
                    reject_user.id,
                    reject_user.user.id,
                    reject_user.user.last_name,
                    abs(reject_user.amount),
                    TRANS_STATUS.getDesc(reject_user.state)
                )
                dt_result.append(x)
                print reject_user.id
            except Exception as e:
                print e.message
                continue
        open(u'被驳回提现详细信息.xlsx', 'wb').write(dt_result.xlsx)
        file_path = '被驳回提现详细信息.xlsx'.decode('utf-8')
        data = xlrd.open_workbook(file_path)
        table = data.sheet_by_index(0)
        ids = table.col_values(0)[1:]
        start = 0
        step = 100
        while start <= len(ids):
            objs = TransactionLog.objects.filter(id__in=ids[start:start + step]).update(state=TRANS_STATUS.REJECT)
            start += step
        print 'DONE!!!'



normal_user_ids = [29803191, 29909556, 30023759, 30025593, 30026133, 30027453, 30030097, 30030783, 30031107, 30031208, 30031645, 30032112, 30032326, 30032426, 30032520, 30032781, 30032801, 30032854, 30032971, 30033102, 30033128, 30033336, 30033403, 30034266, 30034281, 30034517, 30034959, 30034973, 30035021, 30036061, 30036167, 30036222, 30036254, 30037598, 30039344, 30039757, 30040282, 30040592, 30040778, 30040881, 30040985, 30040998, 30041294, 30041483, 30041515, 30042031, 30042046, 30042935, 30044717, 30044924, 30045098, 30045951, 30046710, 30047271, 30049124, 30049675, 30050556, 30051227, 30052678, 30052858, 30053090, 30055458, 30055685, 30056230, 30058765, 30058793, 30060488, 30061300, 30061732, 30061950, 30062231, 30063451, 30063644, 30063871, 30064214, 30066484, 30066933, 30068490, 30069011, 30069792, 30070357, 30071196, 30071315, 30071977, 30074846, 30075350, 30075635, 30077247, 30077646, 30078636, 30079224, 30080173, 30080772, 30081735, 30082787, 30083946, 30084173, 30087308, 30088058, 795393, 29379215, 29709028, 30018528, 30024377, 30024510, 30024537, 30025015, 30025153, 30025233, 30025598, 30027690, 30028101, 30029088, 30029945, 30030815, 30031212, 30031714, 30031996, 30032228, 30032677, 30033548, 30033576, 30033644, 30033924, 30034531, 30034677, 30034985, 30035208, 30035651, 30036629, 30036647, 30037278, 30037886, 30038078, 30039199, 30039259, 30039574, 30040366, 30040393, 30041097, 30041164, 30043841, 30043919, 30044440, 30045600, 30045670, 30046185, 30046811, 30046921, 30047208, 30047448, 30048592, 30048661, 30048731, 30049724, 30049963, 30051844, 30052272, 30053106, 30054648, 30054703, 30054841, 30055268, 30055501, 30055620, 30056937, 30058011, 30058114, 30059560, 30061456, 30062382, 30063523, 30066371, 30068314, 30070433, 30070970, 30071985, 30073626, 30074690, 30075078, 30077368, 30078188, 30078622, 30078867, 30079199, 30081958, 30082261, 30082437, 30083171, 30084308, 30084583, 30089956, 30032584, 29038974, 30024790, 30026051, 30026346, 30027656, 30030078, 30030862, 30031309, 30034547, 30035007, 30035897, 30038013, 30039960, 30040822, 30040858, 30041959, 30042704, 30043280, 30043382, 30044883, 30045684, 30046192, 30046200, 30049729, 30050037, 30051456, 30053012, 30053460, 30057436, 30057766, 30060507, 30061584, 30062037, 30062510, 30063963, 30065427, 30066929, 30067890, 30069467, 30073939, 30075524, 30075774, 30077800, 30089122, 30089685]