# coding=utf-8
from django.core.management import BaseCommand
from openpyxl import load_workbook

from api.models import Order, OrderCost


class Command(BaseCommand):
    """
    将 1月核心医生验证订单涉及成本明细.xlsx 放在gaia目录下
    python manage.py insert_20170207_order_cost
    批量录入订单成本
    created by chenfeifei 2017-02-07
    """

    def handle(self, *args, **options):
        wb = load_workbook(filename=u'1月核心医生验证订单涉及成本明细.xlsx')
        sheetnames = wb.get_sheet_names()
        ws = wb.get_sheet_by_name(sheetnames[0])
        for rx in range(2, ws.get_highest_row() + 1):
            try:
                order = Order.objects.get(id=ws.cell(row=rx, column=1).value)
                order_cost = OrderCost.objects.create(order=order, cost_price=ws.cell(row=rx, column=2).value)
                print order.id, order_cost.id
            except Exception as e:
                print ws.cell(row=rx, column=1).value, e.message
        print u'Done!'
