# coding=utf-8
from django.core.management import BaseCommand
from gm_types.gaia import COUPON_DISTRIBUTION_STATUS

from api.models import Coupon
from api.models import ChannelGift


class Command(BaseCommand):
    """
    python manage.py update_20170320_set_coupon_distribution_status
    批量设置美券生效状态
    批量设置礼包在渠道中的初始值
    """

    def handle(self, *args, **options):
        coupons = Coupon.objects.filter(activated_time__isnull=False, distribution_status=COUPON_DISTRIBUTION_STATUS.DRAFT)
        for coupon in coupons:
            try:
                coupon.distribution_status = COUPON_DISTRIBUTION_STATUS.OPEN
                coupon.save()
                print coupon.id
            except Exception as e:
                print coupon.id, e.message
                continue
        print "COUPON DONE START CHANNEL"
        channels = ChannelGift.objects.filter(activated_time__isnull=True, gift_enable=True)
        for channel in channels:
            try:
                channel.gift_enable = False
                channel.save()
                print channel.id
            except Exception as e:
                print channel.id, e.message
                continue
        print "DONE!"
