# coding=utf-8

from django.core.management import BaseCommand
from api.models.bd_transfer import BDTransfer
import random, string


class Command(BaseCommand):
    """
    python manage.py update_20191111_bdtransfer_client_id
    商户转诊线索表增加唯一标识：client_id 客户ID
    """
    def handle(self, *args, **options):
        objs = BDTransfer.objects.all()
        for obj in objs:
            #生成client_id
            while True:
                client_id = ''.join(random.sample(string.digits + string.ascii_uppercase, 6))
                if not BDTransfer.objects.filter(client_id=client_id).first():
                    break
            obj.client_id = client_id
            obj.save()
