# coding=utf-8
# create by oldman at 17/3/25
from django.core.management import BaseCommand

from api.models import Doctor, datetime, DOCTOR_TYPE
from api.tool.user_tool import get_user_extra_by_user_id, get_user_by_id


class Command(BaseCommand):
    """
    处理医生注册数据没有同步的医生
    python manage.py upodate_20170325_update_doctor_info_to_user
    created by oldman at 2017-03-25
    """

    def handle(self, *args, **options):
        doctors = Doctor.objects.filter(created_at__gte='2017-03-20 00:00:00')
        for doctor in doctors:
            try:
                extra = get_user_extra_by_user_id(doctor.user.id)
                if (extra and (doctor.portrait != extra.portrait)) or (
                            doctor.user.last_name != u'{} 医生'.format(doctor.name)):

                    user = doctor.user
                    if extra and doctor.portrait:
                        extra.portrait = doctor.portrait
                        extra.save()
                    if doctor.name:
                        name = doctor.name
                        is_doctor = doctor.doctor_type == DOCTOR_TYPE.DOCTOR
                        is_suozhang = doctor.user.id == 22
                        if is_doctor and not is_suozhang:
                            name = u'{} 医生'.format(name)
                        user.last_name = name
                        user.save()
                    print doctor.id
            except Exception as e:
                print(e.message)
                continue
        print u'Done!'
