#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   17/12/08 14:59:59
#   Desc    :   hera related
#

from gm_dataquery.db import DB
from gm_dataquery.dataquery import DataSQLQuery

from hera.models import Config


@DB
class ConfigDQ(DataSQLQuery):
    model = Config

    def create(self, **kwargs):
        raise Exception(u'不应该调用这个方法')

    def update(self, updates, **kwargs):
        for key, value in updates.items():
            Config.objects.update_or_create(key=key, defaults={'value': value})

    def process(self, columns=None, **kwargs):
        if columns is None:
            columns = []
        items = Config.objects.filter(key__in=columns)
        data = [{i.key: i.value for i in items}]
        data[0]['id'] = 1
        return {
            'count': 1,
            'data': data
        }
