# coding=utf-8
# create by oldman at 2017/11/3
from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery

from hippo.models.bill import BillApplyRecord, DoctorFinanceInfo


class DoctorFinanceInfoDB(DataBuilder):
    def getval_account_name(self, obj):
        return obj.doctor.merchant.account.account_name


class DoctorFinanceInfoDQ(DataSQLQuery):
    model = DoctorFinanceInfo
    data_model = DoctorFinanceInfoDB
    distinct = True

    def filter_account_name(self, srch_key, srch_val, regex=False):
        return Q(doctor__account__account_name__contains=srch_val)

    def filter_bill_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)
