# -*- coding: UTF-8 -*-

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_types.gaia import ORDER_STATUS, FENXIAO_PAY_RULE
from api.models import FenxiaoCompany, FenxiaoOrderWanghong
from gm_dataquery.db import DB


class FenxiaoCompanyDB(DataBuilder):
    def getval_pay_type(self, obj):
        return FENXIAO_PAY_RULE.getDesc(obj.pay_type)

    def getval_back_rate(self,obj):
        return '%s%%'%str(obj.back_rate)

    def getval_wanghong_num(self,obj):
        return obj.wanghongs.count()


@DB
class FenxiaoCompanyDQ(DataSQLQuery):
    model = FenxiaoCompany
    data_model = FenxiaoCompanyDB


class FenxiaoOrderDB(DataBuilder):
    def getval_order_status(self, obj):
        return ORDER_STATUS.getDesc(obj.order.status)


@DB
class FenxiaoOrderDQ(DataSQLQuery):
    model = FenxiaoOrderWanghong
    data_model = FenxiaoOrderDB

    def filter_order__pay_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)
