# -*- coding: utf-8 -*-

from gm_dataquery.db import DB
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from api.models.face.heidong_scan import HeiDongDimension, HeiDongDimensionDetail, HeiDongDimensionImage
from polymer.models import PolymerTag
from gm_types.gaia import FACIAL_FEATUREA

class HeiDongDimensionDB(DataBuilder):
    pass


@DB
class HeiDongDimensionDQ(DataSQLQuery):
    model = HeiDongDimension
    data_model = HeiDongDimensionDB


class HeiDongDimensionDetailDB(DataBuilder):
    def getval_tags(self, obj):
        return list(
            PolymerTag.objects.filter(polymer_id=obj.polymer_id, is_online=True).values_list("tag_id", flat=True))

    def getval_contour(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.CONTOUR:
            return obj.classification

    def getval_chin(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.CHIN:
            return obj.classification

    def getval_eyebrow(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.EYEBROW:
            return obj.classification

    def getval_eye(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.EYE:
            return obj.classification

    def getval_nose(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.NOSE:
            return obj.classification

    def getval_lip(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.LIP:
            return obj.classification

    def getval_tongjubiyi(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.TONGJU_BIYI_BIZHI:
            return obj.classification

    def getval_shuangCxian(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.SHUANG_C_XIAN_JIAODU:
            return obj.classification

    def getval_renzhongzuichun(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.RENZHONG_ZUICHUN_KEDI_BIZHI:
            return obj.classification

    def getval_zhongxiating(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.ZHONGXIATING:
            return obj.classification

    def getval_wuyan(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.SANYAN_BILI:
            return obj.classification

    def getval_niebuquankuanxiahe(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.NIEBU_QUANKUAN_XIAHE_XIABA_BIZHI:
            return obj.classification

    def getval_niebuquankuan(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.NIEBU_QUANKUAN_BIZHI:
            return obj.classification

    def getval_shuangyanpi(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.SHUANGYANPI_TYPE:
            return obj.classification

    def getval_yandai(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.YANDAI_TYPE:
            return obj.classification

    def getval_falingwen(self, obj):
        if obj.facial_type == FACIAL_FEATUREA.FALINGWEN_TYPE:
            return obj.classification


@DB
class HeiDongDimensionDetailDQ(DataSQLQuery):
    model = HeiDongDimensionDetail
    data_model = HeiDongDimensionDetailDB


class HeiDongDimensionImageDB(DataBuilder):
    pass


@DB
class HeiDongDimensionImageDQ(DataSQLQuery):
    model = HeiDongDimensionImage
    data_model = HeiDongDimensionImageDB


class NanshenFaceTypeDB(DataBuilder):
    pass
