# -*- coding: UTF-8 -*-
import datetime
from django.db import transaction
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from gm_types.push import HERA_TASK_TYPE
from gm_types.gaia import BENEFIT_TYPE
from api.models import PushTask2
from api.models import User, ChannelGift, GiftToCoupon
from rpc.exceptions import GaiaRPCFaultException
from rpc.context import get_rpc_remote_invoker
from gm_types.error import ERROR
from enum import Enum
from gm_types.push import (
    PUSH_USER_TYPE2,
    HERA_PUSH_TYPE2,
    SEND_STATUS,
    HERA_PUSH_PLATFORM,
)

operatetype=((0,''),(1,'重新发送'))


class PushTaskDB2(DataBuilder):
    '''
        处理显示问题
    '''
    def getval_platform(self, obj):
        for item in HERA_PUSH_PLATFORM:
            if item[0]==obj.platform:
                return item[1]
        return "no platform"

    def getval_pushtype(self,obj):
        for item in HERA_PUSH_TYPE2:
            if item[0]==obj.pushtype:
                return item[1]
        return "no pustype"


    def getval_approver_status(self,obj):
        if obj.approver_status:
            return "审核通过"
        return "未审核"

    def getval_status(self,obj):
        '''
            表格显示的状态
        '''
        result=""
        for item in SEND_STATUS:
            if item[0]==obj.status:
                return item[1]

    def getval_operate(self,obj):
        '''
            操作(如果发送失败,操作为重新发送)
        '''
        if obj.status==SEND_STATUS.FAILURE:
            return "重新发送"

        return ""

    def getval_market_id(self, obj):
        return [int(item) for item in eval(obj.market_id)]



@DB
class PushTaskDQ2(DataSQLQuery):
        model = PushTask2
        data_model = PushTaskDB2

        def filter_pushtime(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)

