# coding=utf-8
from django.db.models import Q
from gm_types.gaia import SERVICE_REVIEW_STATUS, SERVICE_SELL_TYPE, OPERTOR_REVIEW_TYPE

from api.models import ServiceRegister, ServiceReviewRecord, ServiceItem, SKUExamine
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB


class ReviewRecordDB(DataBuilder):
    """
    美购待审核实体的返回数据格式
    """

    def getval_review_status(self, obj):
        if obj.is_register:
            return u'新增待审核'
        else:
            return u'修改待审核'

    def getval_content(self, obj):
        if len(ServiceReviewRecord.objects.filter(serviceregister_id=obj.id)) > 0:
            return ServiceReviewRecord.objects.filter(serviceregister_id=obj.id).last().update_data
        else:
            return u''

    def getval_last_submit_time(self, obj):
        if obj.last_submit_time:
            return str(obj.last_submit_time)[0:19]

    def getval_last_review_time(self, obj):
        if obj.last_review_time:
            return str(obj.last_review_time)[0:19]

    def getval_online_time(self, obj):
        if obj.online_time:
            return str(obj.online_time)[0:19]

    def getval_service__id(self, obj):
        if obj.service:
            return obj.service.id
        else:
            return ''

    def getval_is_sekill(self, obj):
        return u''

    def getval_operator_review_type(self, obj):
        return OPERTOR_REVIEW_TYPE.getDesc(obj.operator_review_type)

    def getval_operator_review_type_id(self, obj):
        return obj.operator_review_type

    def getval_service_type_desc(self, obj):
        return SERVICE_SELL_TYPE.getDesc(obj.service_type)


@DB
class ReviewRecordDQ(DataSQLQuery):
    """
    美购待审核实体查询过滤
    """
    model = ServiceRegister
    data_model = ReviewRecordDB

    def filter_high_com_service(self, key, value, regex=False):
        q = Q(service_type=SERVICE_SELL_TYPE.FENGXIANGGOU)
        if not int(value):
            q = ~q
        return q

    def filter_last_submit_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_last_review_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_online_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_review_types(self, srch_key, srch_val, regex=False):
        if srch_val == '1':
            return Q(service__id__isnull=True)
        elif srch_val == '2':
            return Q(service__id__isnull=False)
        else:
            return Q()

    def filter_is_sekill(self, srch_key, srch_val, regex=False):
        if srch_val == '1':
            return Q(service__is_multiattribute=False) | Q(upload_button__isnull=False)
        elif srch_val == '0':
            return Q(service__is_multiattribute=True) | Q(upload_button__isnull=True)
        else:
            return Q()

    def filter_doctor_status(self, srch_key, srch_val, regex=False):
        if srch_val == '7':
            return Q(doctor__status=7)
        else:
            return ~Q(doctor__status=7)
