# -*- coding: UTF-8 -*-
from django.db.models import Sum, FloatField, F, Count
from django.db.models.functions import Coalesce
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from pay.models import Statement
from pay.models.operation import StatementOperation
from gm_types.trade import STATEMENT_OPERATION_TYPE
from api.models import Order
import json


class StatementOrderDB(DataBuilder):
    def getval_service__name(self, obj):
        return json.loads(obj.service_snapshot).get('name')

    def getval_total_number(self, obj):
        return obj.service_price

    def getval_pre_payment_price(self, obj):
        return json.loads(obj.service_snapshot).get('pre_payment_price')

    def getval_settle_price(self, obj):
        return obj.settle_data()['settle_payment']


class StatementOrderDQ(DataSQLQuery):
    model = Order
    data_model = StatementOrderDB
