# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder
from gm_dataquery.db import DB

from talos.models.topic import Problem, PgcClassify
from gm_types.gaia import TOPIC_TYPE
from . import TalosDataSQLQuery


class ProblemDB(DataBuilder):
    def getval_origin(self, obj, default=''):
        origin = TOPIC_TYPE.getDesc(TOPIC_TYPE.WEIXIN_NUM) if obj.topic_type == TOPIC_TYPE.WEIXIN_NUM else u'所长发帖'
        return origin

    def getval_is_online(self, obj, default=''):
        origin = u'是' if obj.is_online else u'否'
        return origin

    def getval_audit_status(self, obj, default=''):
        origin = u'是' if obj.audit_status else u'否'
        return origin


class ProblemDQ(TalosDataSQLQuery):
    model = Problem
    data_model = ProblemDB

    def filter_origin(self, srch_key, srch_val, regex=False):
        q = None
        if srch_val == '1':
            q = Q(topic_type=TOPIC_TYPE.WEIXIN_NUM)
        elif srch_val == '0':
            q = Q(user_id='22')
        return q

    def filter_is_classify(self, srch_key, srch_val, regex=False):
        q = None
        if srch_val == '0':
            q = Q(pgc_classfy__isnull=True)
        elif srch_val == '1':
            q = ~Q(pgc_classfy__isnull=True)
        return q

    def filter_is_tag(self, srch_key, srch_val, regex=False):
        q = None
        if srch_val == '0':
            q = Q(problemtag__tag_id__isnull=True)
        elif srch_val == '1':
            q = ~Q(problemtag__tag_id__isnull=True)
        return q


class PgcClassifyDB(DataBuilder):

    def getval_is_online(self, obj, default=''):
        origin = u'是' if obj.is_online else u'否'
        return origin


@DB
class PgcClassifyDQ(TalosDataSQLQuery):
    model = PgcClassify
    data_model = PgcClassifyDB
