# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.db import DB
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery

from api.models import User
from talos.models.live import ShortvideoBlackList
from . import TalosDataSQLQuery


class ShortvideoBlackListDB(DataBuilder):
    def getval_user_name(self, obj):
        user = User.objects.get(id=obj.user_id)
        return user.last_name

    def getval_user_tel(self, obj):
        user = User.objects.get(id=obj.user_id)
        phone = user.person.phone
        return phone[0:3] + '****' + phone[7:] if phone else ''


@DB
class ShortvideoBlackListDQ(TalosDataSQLQuery):
    model = ShortvideoBlackList
    data_model = ShortvideoBlackListDB

    def filter_user_tel(self, srch_key, srch_val, regex=False):
        users = User.objects.filter(person__phone=srch_val)
        return Q(user_id__in=[u.id for u in users])

    def filter_user_name(self, srch_key, srch_val, regex=False):
        users = User.objects.filter(last_name=srch_val)
        return Q(user_id__in=[u.id for u in users])
