# -*- coding: UTF-8 -*-

from celery import shared_task
from api.models import Order, SpecialItem, SKUPriceRule, ServiceItemPrice, DoctorSeckillApply, SpecialResource, \
    SpecialLayout
from rpc.tool.dict_mixin import to_dict
from api.models import SpecialRelatedTag

@shared_task
def add_purchase_list(special_id, special, skupricerule):
    """
    复制秒杀专场  秒杀专题美购列表
    :param special_id:  原先的秒杀专场id
    :param special:  新的专题
    :return:
    """
    old_specialitem = SpecialItem.objects.filter(special_id=special_id)
    for specialitem in old_specialitem:
            serviceitemprice = ServiceItemPrice.objects.filter(service_item_id=specialitem.serviceitem_id,
                                                               selling_rule_id=skupricerule.id).first()
            doctorseckillapply_id = specialitem.doctorseckillapply_id
            if doctorseckillapply_id and serviceitemprice:
                doctorseckillapply = DoctorSeckillApply.objects.get(id=doctorseckillapply_id)
                if doctorseckillapply.left_stock == 0:
                    continue
                if doctorseckillapply.left_stock < serviceitemprice.sale_limit:
                    serviceitemprice.sale_limit = doctorseckillapply.left_stock
                    serviceitemprice.save()
            new_specialitem, _ = SpecialItem.objects.get_or_create(
                name=specialitem.name,
                subtitle=specialitem.subtitle,
                image_url=specialitem.image_url,
                doctor=specialitem.doctor,
                topic_id=specialitem.topic_id,
                diary_id=specialitem.diary_id,
                service=specialitem.service,
                special=special,
                rank=specialitem.rank,
                position=specialitem.position,
                is_recommend=specialitem.is_recommend,
                serviceitem=specialitem.serviceitem,
                doctorseckillapply=specialitem.doctorseckillapply,
                sell_num=specialitem.sell_num,
                tip=specialitem.tip,
                floor_id=specialitem.floor_id,
            )

            if serviceitemprice:
                new_specialitem.update_or_create_price_info(serviceitemprice.sale_limit)


@shared_task
def add_specialresource(special_id, special):
    # 创建资源位
    specialresource_list = []
    old_specialresource = SpecialResource.objects.filter(special_id=special_id)
    for specialresource in old_specialresource:
        specialresource_list.append(SpecialResource(
            special_id=special.id,
            rank=specialresource.rank,
            image_data=specialresource.image_data,
        ))
    SpecialResource.objects.bulk_create(specialresource_list)


@shared_task
def add_speciallayout(special_id, special):
    speciallayout_list = []
    old_speciallayout = SpecialLayout.objects.filter(special_id=special_id)
    for speciallayout in old_speciallayout:
        speciallayout_list.append(SpecialLayout(
            special=special,
            is_visible=speciallayout.is_visible,
            module=speciallayout.module,
            related=speciallayout.related,
        ))
    SpecialLayout.objects.bulk_create(speciallayout_list)


@shared_task
def create_new_special_floor_data(related_dict):
    for k, v in related_dict.iteritems():
        old_special_id, old_child_storey_id, new_special_id, new_child_storey_id = k + v

        # 创建楼层关联tag
        related_tag_objs = []
        tag_ids = list(SpecialRelatedTag.objects.filter(
            special_id=old_special_id, floor_id=old_child_storey_id
        ).values_list('tag_id', flat=True))
        for tag_id in tag_ids:
            related_tag_objs.append(SpecialRelatedTag(
                special_id=new_special_id, floor_id=new_child_storey_id, tag_id=tag_id)
            )

        SpecialRelatedTag.objects.bulk_create(related_tag_objs)

        # 创建该楼层下关联的美购列表
        old_special_items = SpecialItem.objects.filter(special_id=old_special_id, floor_id=old_child_storey_id)

        # 创建新的美购列表数据
        for old_special_item in old_special_items:
            new_special_item_data = to_dict(
                old_special_item,
                fields=['name', 'subtitle', 'image_url', 'doctor_id',
                        'topic_id', 'diary_id', 'service_id',
                        'rank', 'position', 'is_recommend', 'serviceitem_id',
                        'doctorseckillapply_id', 'sell_num', 'tip']
            )
            new_special_item_data['floor_id'] = new_child_storey_id
            new_special_item_data['special_id'] = new_special_id
            specialitem = SpecialItem.objects.create(**new_special_item_data)
            specialitem.update_or_create_price_info()


@shared_task
def create_serviceitem_prices(new_special_id):
    specialitems = SpecialItem.objects.filter(special_id=new_special_id, floor_id__null=True)
    for specialitem in specialitems:
        specialitem.update_or_create_price_info()
