# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function


from ..audit import audit_write_log, get_audit_log_data
from api.models import SimpleActionLog

from rpc.decorators import bind_context
from rpc.exceptions import RPCPermissionDeniedException


@bind_context(
    'api/audit_log/write',
    login_required=True,
    staff_required=True,
)
def write(ctx, package, action, object_type=None, object_id=None, message=None):
    """
    {-# Straight Configuration Alpha Typedef #-}
    data Params = {
        package     : Str
        action      : Str
        object_type : Str | None | Void
        object_id   : Any | None | Void
        message     : Str | None | Void
    }
    data Result = None
    {-# Straight End #-}
    """
    user = ctx.session.user
    audit_write_log(
        user=user,
        package=package,
        action=action,
        object_type=object_type,
        object_id=object_id,
        message=message,
        )


@bind_context(
    'api/operation/audit/write_log',
    login_required=True,
    staff_required=True,
)
def deprecated_write_log(ctx, package, action, object_type=None, object_id=None, message=None):
    user = ctx.session.user
    audit_write_log(
        user=user,
        package=package,
        action=action,
        object_type=object_type,
        object_id=object_id,
        message=message,
        )


@bind_context(
    'api/audit_log/write_for_multiple_objects',
    login_required=True,
    staff_required=True,
)
def write_for_multiple_objects(ctx, package, action, object_type, object_id_list, message=None):
    """
    {-# Straight Configuration Alpha Typedef #-}
    data Params = {
        package        : Str
        action         : Str
        object_type    : Str
        object_id_list : Array[Any]
        message        : Str | None | Void
    }
    data Result = None
    {-# Straight End #-}
    """

    user = ctx.session.user

    for object_id in object_id_list:
        audit_write_log(
            user=user,
            package=package,
            action=action,
            object_type=object_type,
            object_id=object_id,
            message=message,
        )


@bind_context(
    'api/audit_log/query_mine',
    login_required=True,
    staff_required=True,
)
def query_mine(ctx, package=None, action=None, start_num=0, count=20):
    """
    {-# Straight Configuration Alpha Typedef #-}
    data Params = {
        package   : Str | None | Void
        action    : Str | None | Void
        start_num : Int | Void
        count     : Int | Void
    }
    data Result = Array[Any]
    {-# Straight End #-}
    """

    user = ctx.session.user

    result_set = SimpleActionLog.objects.all()
    result_set = result_set.filter(user=user)
    if package is not None:
        result_set = result_set.filter(package=package)
    if action is not None:
        result_set = result_set.filter(action=action)

    result_set = result_set[start_num:start_num+count]

    return [
        get_audit_log_data(audit_log)
        for audit_log in result_set
    ]


@bind_context(
    'api/operation/audit/query_my_log',
    login_required=True,
    staff_required=True,
)
def deprecated_query_my_log(ctx, package=None, action=None):
    user = ctx.session.user

    result_set = SimpleActionLog.objects.all()
    result_set = result_set.filter(user=user)
    if package is not None:
        result_set = result_set.filter(package=package)
    if action is not None:
        result_set = result_set.filter(action=action)

    return [
        get_audit_log_data(audit_log)
        for audit_log in result_set
    ]
