# coding=utf-8
from hera.queries.packageservice import PackageServiceDQ
from hera.queries.skupricelog import SKUPriceLogDQ
from rpc.context import get_rpc_remote_invoker
from rpc.decorators import bind_context
from api.models import Service, Tag, ServiceTag, ServiceItem, ServiceRegister, ServiceReviewRecord, \
    ServiceRegisterItem, Q, PackageServiceRemark, SimpleActionLog, AuditAttrOptions
from django.db import IntegrityError, transaction
from rpc.exceptions import RPCIntegrityError, RPCNotFoundException
from rpc.tool.log_tool import info_logger
from rpc.tool.dict_mixin import to_dict
from gm_types.gaia import SERVICE_REVIEW_STATUS, YINUO_TYPE, TAG_TYPE, SERVICE_SELL_TYPE
from ..models import UserPerm
from ..utils import check_business, check_operate, operate_business
from datetime import datetime
import json

uri_pre = 'hera/packageservice'
special_approve = 'hera/specialapprove'


@bind_context(special_approve + '/query')
def specialapprovel_query(ctx, options):
    init_q = Q(review_status=SERVICE_REVIEW_STATUS.SPECIAL_UNDER_REVIEW)
    if check_operate(ctx.session.user_id):
        business_ids = operate_business(ctx.session.user_id)
        init_q &= Q(doctor__business_partener__id__in=business_ids)
    elif check_business(ctx.session.groups):
        # 判断是商务并且非商务leader
        user = ctx.session.user
        members = UserPerm.members(user)
        init_q &= Q(doctor__business_partener__in=members)
    dqobj = PackageServiceDQ(init_q=init_q)
    return dqobj.process(**options)


@bind_context(uri_pre + '/query')
def packageservice_query(ctx, options):
    init_q = Q(review_status=SERVICE_REVIEW_STATUS.PASS)
    if check_business(ctx.session.groups):
        # 判断是商务并且非商务leader
        user = ctx.session.user
        members = UserPerm.members(user)
        init_q &= Q(doctor__business_partener__in=members)
    elif check_operate(ctx.session.user_id):
        business_ids = operate_business(ctx.session.user_id)
        init_q &= Q(doctor__business_partener__id__in=business_ids)
    dqobj = PackageServiceDQ(init_q=init_q)
    return dqobj.process(**options)


@bind_context(special_approve + '/edit')
@transaction.atomic
def specialapprovel_edit(ctx, servicereg_id=None, service_info=None):
    if servicereg_id is None:
        return None
    attr_items = service_info.pop('attr_items', [])
    if service_info is None:
        return None
    else:
        try:
            servicereg = ServiceRegister.objects.get(id=servicereg_id)
        except:
            info_logger.info(__import__('traceback').format_exc())
            raise RPCNotFoundException
        if servicereg.review_status != SERVICE_REVIEW_STATUS.SPECIAL_UNDER_REVIEW:
            return -1
        servicereg.review_status = service_info['state']
        servicereg.save()
        # next save ServiceReviewRecord记录
        record = servicereg.servicereviewrecord_set.all().last()
        if record:
            record.now_review_status = service_info['state']
            record.reason = service_info['reason']
            record.audit_time = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
            record.operator = ctx.session.user.person
            record.save()
    for attr_item in attr_items:
        service_item = ServiceRegisterItem.objects.get(id=attr_item.pop('id'))
        for ks, vs in attr_item.iteritems():
            setattr(service_item, ks, vs)
        service_item.save()
    return servicereg_id


@bind_context(special_approve + '/get')
def specialapprovel_get(ctx, servicereg_id, options=None):
    """
    获取美购注册根据id
    """
    try:
        servicreg = ServiceRegister.objects.get(id=servicereg_id)
    except Exception, ex:
        raise RPCNotFoundException
    if options is None:
        options = {
            'fields': None,
            'excludes': None,
            'expands': None,
        }
    service_data = {}
    service_data['id'] = servicereg_id
    service_data['service_type'] = servicreg.service_type
    # service_data['itemwiki'] = list(
    #     ServiceItemWiki.objects.filter(service_id=service.id).values_list('itemwiki_id', flat=True))
    items = []
    attrs_parent = []
    temp_attr = []
    service_items = servicreg.items.filter(is_online=True).filter(is_delete=False)
    for item in service_items:
        service_keys = item.serviceregisteritemkey_set.all()
        determine_items = {}
        for service_key in service_keys:
            determine_item = service_key.serviceregisterattroption
            determine_item_parent_name = getattr(determine_item.tag_attr if hasattr(determine_item, 'tag_attr')
                                                 else '', 'name', '项目名称')
            determine_item_parent_id = getattr(determine_item.tag_attr if hasattr(determine_item, 'tag_attr')
                                               else '', 'id', 'xiangmumingcheng')
            auditattroptions = AuditAttrOptions.objects.filter(serviceregisteritem=service_key.serviceregisteritem).first()
            if auditattroptions:
                determine_item_name = auditattroptions.name
            else:
                determine_item_name = determine_item.name
            determine_dict = {
                determine_item_parent_id: determine_item_name
            }
            if determine_item_parent_id not in temp_attr:
                temp_attr.append(determine_item_parent_id)
                attrs_parent.append({'item_parent_id': determine_item_parent_id,
                                     'item_parent_name': determine_item_parent_name})
            determine_items.update(determine_dict)
        item_data = to_dict(item)
        item_data['determine_items'] = determine_items
        item_data['serviceitem_id'] = item.serviceitem.id if item.serviceitem else u''
        item_data['city_name'] = item.city.name if item.city else ''
        items.append(item_data)
    service_data['attr_items'] = items
    service_data['attr_items_head'] = attrs_parent
    service_data['service_lock'] = getattr(servicreg.service, 'is_lock', False)
    return service_data


@bind_context(uri_pre + '/edit')
@transaction.atomic
def packageservice_edit(ctx, service_id=None, service_info=None):
    if service_info is None:
        return None
    service_info.pop('id', '')
    service_info.pop('servicereg_id', '')
    attr_items = service_info.pop('attr_items', [])
    service_info.pop('photo_details_doctor')
    tags = service_info.pop('tags', [])
    specialtags = service_info.pop('specialtag', [])
    tags = tags + specialtags
    service_info['wiki_id'] = service_info.pop('wiki')
    service_info['is_insurance'] = not (service_info.get('yinuo_type') == YINUO_TYPE.NONE)
    if service_id is None:
        return None
    else:
        try:
            service = Service.objects.get(id=service_id)
        except:
            info_logger.info(__import__('traceback').format_exc())
            raise RPCNotFoundException
        for k, v in service_info.iteritems():
            setattr(service, k, v)
        # top save self
        # next save serviceregister 相关的数据
        service_register = service.servicereg.all()
        if service_register and service_register[0].is_register:
            if service_register[0].review_status != SERVICE_REVIEW_STATUS.PASS:
                return -1
            from datetime import datetime
            service_register[0].online_time = datetime.now()
            service_register[0].is_register = False
            service_register[0].save()
            setattr(service, 'is_online', True)
        setattr(service, 'sell_num_limit', service.real_stock)
        service.save()
        # doctor
        service.smart_self_support()
        # next save tag
        if tags:
            new_tags = set(Tag.objects.filter(id__in=tags))
            old_tags = set(service.tags.all())
            for tag_obj in (new_tags - old_tags):
                ServiceTag.objects.get_or_create(
                    service_id=service.id,
                    tag=tag_obj)
            ServiceTag.objects.filter(
                service_id=service.id,
                tag__in=(old_tags - new_tags),
            ).delete()
        # next save attr
        for attr_item in attr_items:
            service_item = ServiceItem.objects.get(id=attr_item['id'])
            service_item.cost_price = attr_item.pop('cost_price', 0)
            service_item.save(update_fields=['cost_price'])
            price_info = service_item.get_default_price_info()
            if attr_item['cash_back_fee'] and attr_item['cash_back_fee']:
                service_item.update_price(price_id=price_info['id'],
                                      cash_back_fee=attr_item['cash_back_fee'],
                                      cash_back_rate=attr_item['cash_back_rate'],
                                      self_support_discount=attr_item['self_support_discount']
                                      )
            else:
                service_item.update_price(price_id=price_info['id'],
                                      self_support_discount=attr_item['self_support_discount'])

            #  无申请id的活动价同步更新
            activity_ids = service_item.specialitem_set.filter(doctorseckillapply__isnull=True).\
                values_list('special_id', flat=True)
            price_ids = service_item.serviceitemprice_set.filter(selling_rule__activity_id__in=activity_ids).\
                values_list('id', flat=True)
            for price_id in price_ids:
                if attr_item['cash_back_fee'] and attr_item['cash_back_rate']:
                    service_item.update_price(price_id=price_id,
                                          cash_back_fee=attr_item['cash_back_fee'],
                                          cash_back_rate=attr_item['cash_back_rate'],
                                          self_support_discount=attr_item['self_support_discount'])
                else:
                    service_item.update_price(price_id=price_id, self_support_discount=attr_item['self_support_discount'])
            # setattr(service_item, 'cash_back_fee', attr_item['cash_back_fee'])
            # setattr(service_item, 'cash_back_rate', attr_item['cash_back_rate'])
            # setattr(service_item, 'self_support_discount', attr_item['self_support_discount'])
            # service_item.save()
        # save remark record
        packageserviceremark = PackageServiceRemark(
            service_id=service_id,
            person=ctx.session.user.person,
            remark=service_info['notes'],
        )
        packageserviceremark.save()
    return service_id


@bind_context(uri_pre + '/get')
def packageservice_get(ctx, service_id, options=None):
    """
    获取美购根据id
    """
    try:
        service = Service.objects.get(id=service_id)
    except Exception, ex:
        raise RPCNotFoundException
    if options is None:
        options = {
            'fields': None,
            'excludes': None,
            'expands': None,
        }
    service_data = to_dict(service, **options)

    # 筛选出个性化标签
    tags = service_data.get('tags',[])
    commontag = []
    specialtag = []
    if tags:
        for tag_obj in tags:
            service_obj = ServiceTag.objects.get_or_create(
                service_id=service.id,
                tag=tag_obj)
            tag = Tag.objects.get_or_create(id=service_obj[0].tag_id)
            if tag[0].tag_type == TAG_TYPE.YUNYING:
                specialtag.append(tag_obj)
            else:
                commontag.append(tag_obj)
    service_data['specialtag'] = specialtag
    service_data['tags'] = commontag
    # service_data['itemwiki'] = list(
    #     ServiceItemWiki.objects.filter(service_id=service.id).values_list('itemwiki_id', flat=True))
    service_data['order_amount'] = service.real_order_amount
    service_data['is_register'] = service.servicereg.all()[0].is_register
    service_data['stock'] = service.sell_num_limit
    service_data['is_register'] = getattr(service.servicereg, 'is_register', False)
    service_data['is_floor_price'] = u'是' if service.is_floor_price else u'否'
    service_data['button_prefix'] = getattr(service.servicereg.all().last().upload_button, 'button_prefix', '')
    service_data['is_online'] = u'是' if service.is_online else u'否'
    service_data['doctor_name'] = getattr(service.doctor, 'name', '')
    service_data['hospital_name'] = getattr(service.doctor.hospital, 'name', '')
    service_data['tags_name'] = getattr(service.project_type, 'name', '')
    service_data['sell_time'] = '%s---%s' % (getattr(service, 'start_time', ''),
                                             getattr(service, 'end_time', '')
                                             )
    service_data['business_partener_name'] = getattr(service.doctor.business_partener, 'username', u'无')
    # 美购改版 2017-03-31
    service_data['supplement_images'] = service.get_supplement_images()
    service_data['recommend_services'] = service.get_recommend_services()
    service_data['service_type'] = service.service_type
    service_data['service_type_desc'] = SERVICE_SELL_TYPE.getDesc(service.service_type)

    # 后台展示注册id
    try:
        service_data['servicereg_id'] = service.servicereg.last().id
    except:
        service_data['servicereg_id'] = ''

    # next多属性是否需要添加
    items = []
    temp_attr = []
    attrs_parent = []
    service_items = service.items.filter(is_delete=False)
    for item in service_items:
        service_keys = item.serviceitemkey_set.all()
        determine_items = {}
        for service_key in service_keys:
            determine_item = service_key.serviceattroption
            determine_item_name = determine_item.name
            determine_item_parent_name = getattr(determine_item.tag_attr if hasattr(determine_item, 'tag_attr')
                                                 else '', 'name', '项目名称')
            determine_item_parent_id = getattr(determine_item.tag_attr if hasattr(determine_item, 'tag_attr')
                                               else '', 'id', 'xiangmumingcheng')
            determine_dict = {
                determine_item_parent_id: determine_item_name
            }
            if determine_item_parent_id not in temp_attr:
                temp_attr.append(determine_item_parent_id)
                attrs_parent.append({'item_parent_id': determine_item_parent_id,
                                     'item_parent_name': determine_item_parent_name})
            determine_items.update(determine_dict)
        price_info = item.get_default_price_info()
        item_data = {'determine_items': determine_items}
        item_data.update(price_info)
        try:
            item_data['discount_rate'] = int(item_data.get('discount') / (item_data.get('gengmei_price') * 1.0) * 100)
        except:
            info_logger.info(__import__('traceback').format_exc())
            item_data['discount_rate'] = 0
        # item_data = to_dict(item)
        item_data['id'] = item.id
        item_data['sku_stock'] = item.sku_stock
        item_data['self_support_discount_rate'] = int(item_data['self_support_discount'] * 1.0/item_data['gengmei_price'] * 100)
        # item_data['cost_price'] = item.cost_price
        item_data['cost_price'] = item.cost_price
        item_data['city_name'] = item.city.name if item.city else ''
        items.append(item_data)
    service_data['attr_items'] = items
    service_data['attr_items_head'] = list(attrs_parent)
    # add package record
    service_data['remarks'] = get_package_remark(service_id)
    service_data['logs'] = get_logs(service.servicereg.all().last().id)
    # 是否是商务
    service_data['is_business'] = False
    if 'business' in ctx.session.groups:
        service_data['is_business'] = True
    service_data['is_lock'] = service.is_lock
    service_data['merchant'] = service.get_merchant().get('name','') if service.get_merchant() else ''
    return service_data


# 获取日志
@bind_context(uri_pre + '/get_log')
def get_all_logs(ctx, servicereg_id):
    return get_logs(servicereg_id)


def get_logs(servicereg_id):
    logs = {
        'apply_log': get_apply_logs(servicereg_id),
        'package_log': get_package_logs(servicereg_id),
    }
    return logs


# 获取申请日志 record——view
def get_apply_logs(servicereg_id):
    apply_log = ServiceReviewRecord.objects.filter(serviceregister_id=servicereg_id)
    logs = []
    for log in apply_log:
        logs.append({
            'person': log.person.user.last_name,
            'created_time': str(log.created_time).split('.')[0],
            'update_data': log.update_data,
            'now_review_status': log.now_review_status,
        })

    return logs


# 获取包装日志 日志表里去读取
def get_package_logs(servicereg_id):
    try:
        servicereg = ServiceRegister.objects.get(id=servicereg_id)
    except Exception, ex:
        raise RPCNotFoundException
    service = getattr(servicereg, 'service', '')
    package_log = []
    if service:
        package_log = SimpleActionLog.objects.filter(
            Q(object_id_json=('"%s"' % str(service.id))) | Q(object_id_json=service.id)).filter(
            object_type='service')
    logs = []
    for log in package_log:
        logs.append({
            'user': log.user.username,
            'action_time': str(log.action_time),
            'message': log.message,
        })
    return logs


# 驳回/医生申请记录
@bind_context(uri_pre + '/get_audit_records')
def get_audit_records(ctx, servicereg_id):
    try:
        servicereg = ServiceRegister.objects.get(id=servicereg_id)
    except Exception, ex:
        raise RPCNotFoundException
    explanation = servicereg.record_info()
    for ex in explanation:
        ex['time'] = str(datetime.fromtimestamp(ex['time'])) if ex['time'] else ''
    return explanation


# 美购包装备注需改/获取包装记录 在get里面获取时候调用这个 记得在edit里面添加一条备注记录.
def get_package_remark(service_id):
    all_remark_set = PackageServiceRemark.objects.filter(service_id=service_id)
    logs = []
    for log in all_remark_set:
        logs.append({
            'person': log.person.user.username,
            'created_time': str(log.created_time).split('.')[0],
            'remark': log.remark,
        })
    return logs


@bind_context(uri_pre + '/get_sku')
def skulog_query(ctx, sku_id):
    sku = ServiceItem.objects.get(id=sku_id)
    price = sku.get_current_price_info()
    return {
        'id': sku.id,
        'name': ''.join(sku.items_name),
        'gengmei_price': price['gengmei_price'],
        'pre_payment_price': price['pre_payment_price'],
        'discount': price['discount'],
        'activity_id': price['selling_rule']['activity_id'] if price.get('selling_rule') else ''
    }


@bind_context(uri_pre + '/sku/log/query')
def skulog_query(ctx, options):
    dqobj = SKUPriceLogDQ()
    return dqobj.process(**options)
