# -*- coding: UTF-8 -*-

from rpc.decorators import bind_context
from ..datatables import ReservationDT
from api.models import Reservation
from ..queries.reservation import ReservationDQ

uri_pre = 'hera/reservation'


@bind_context(uri_pre + '/query')
def reservation_query(ctx, options):
    dqobj = ReservationDQ()
    return dqobj.process(**options)


@bind_context(uri_pre+'/list')
def reservation_datatable(ctx, req_data):
    dtobj = ReservationDT(Reservation)
    return dtobj.process(req_data)