# coding=utf-8
# create by oldman at 2018/5/30
from django.core.management import BaseCommand

from hippo.models import DoctorAccount
from hippo.models import Merchant
from hippo.models import MerchantAccount


class Command(BaseCommand):
    """
    python update_2018_05_29_async_merchant_account_info
    同步商户的账户信息
    """

    def handle(self, *args, **options):
        merchants = Merchant.objects.filter(is_online=True)
        for merchant in merchants:
            try:
                print merchant.id
                accountinfo = DoctorAccount.objects.get(doctor_id=merchant.doctor.id)
                merchantaccount, _ = MerchantAccount.objects.get_or_create(merchant=merchant)
                merchantaccount.country = accountinfo.country
                merchantaccount.province = accountinfo.province
                merchantaccount.city = accountinfo.city
                merchantaccount.bank = accountinfo.bank
                merchantaccount.subbranch = accountinfo.subbranch
                merchantaccount.account_name = accountinfo.account_name
                merchantaccount.account_number = accountinfo.account_number
                merchantaccount.account_type = accountinfo.account_type
                merchantaccount.status = 0
                merchantaccount.city_finance = accountinfo.city_finance
                merchantaccount.save()

            except Exception as e:
                print e.message
                continue
