# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import


import weakref


class Signal(object):

    def __init__(self):
        self._handler_set = weakref.WeakSet()

    def __iadd__(self, other):
        self._handler_set.add(other)

    def __call__(self, *args, **kwargs):
        for h in self._handler_set:
            h(*args, **kwargs)

