# coding=utf-8
from django.conf import settings
from gm_dbmw_api.descriptor import source, relation
from gm_types.mq.dbmw import DBMWEndPoints

pk_data_source = source.GroupedSource.of(
    source.MySQLTableSource(
        logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
        table_name="api_problem",
        key_columns=['id'],
        value_columns_excluded=[],
        value_columns_all=True,
    ),
    source.RelatedSource(
        source=source.GroupedSource.of(
            source.MySQLTableSource(
                logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
                table_name="api_problemtag",
                key_columns=['id'],
                value_columns_excluded=[],
                value_columns_all=True,
            ),
            source.RelatedSource(
                source=source.MySQLTableSource(
                    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                    table_name="api_tag",
                    key_columns=['id'],
                    value_columns_excluded=[],
                    value_columns_all=True,
                ),
                relation=relation.MySQLTableRelation(
                    logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
                    table_name="api_problemtag",
                    from_columns=["tag_id"],
                    to_columns=["id"],
                )
            )
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_problemtag",
            from_columns=["id"],
            to_columns=["problem_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_topicreply",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_topicreply",
            from_columns=["id"],
            to_columns=["problem_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_topicvote",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_topicvote",
            from_columns=["id"],
            to_columns=["topic_id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_topicrankingscore",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_topicrankingscore",
            from_columns=["id"],
            to_columns=["topic_id"],
        )
    ),
    source.RelatedSource(
        source=source.GroupedSource.of(
            source.MySQLTableSource(
                logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
                table_name="api_diary",
                key_columns=['id'],
                value_columns_excluded=[],
                value_columns_all=True,
            ),
            source.RelatedSource(
                source=source.MySQLTableSource(
                    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                    table_name="api_service",
                    key_columns=['id'],
                    value_columns_excluded=[],
                    value_columns_all=True,
                ),
                relation=relation.MySQLTableRelation(
                    logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
                    table_name="api_diary",
                    from_columns=["service_id"],
                    to_columns=["id"],
                )
            ),
            source.RelatedSource(
                source=source.GroupedSource.of(
                    source.MySQLTableSource(
                        logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
                        table_name="api_doctor",
                        key_columns=['id'],
                        value_columns_excluded=['view_num', 'reply_num', 'new_pm_num', 'reply_pm_num', 'no_reply_pm_num',
                                                'share_topic_num', 'last_answered_time'],
                        value_columns_all=True,
                    ),
                    source.GMMQSource(
                        endpoint=DBMWEndPoints.PUNISHMENT_TRIGGER,
                    )
                ),
                relation=relation.MySQLTableRelation(
                    logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
                    table_name="api_diary",
                    from_columns=["doctor_id"],
                    to_columns=["id"],
                )
            )
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_problem",
            from_columns=["diary_id"],
            to_columns=["id"],
        )
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_topic_video",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
            table_name="api_topic_video",
            from_columns=["id"],
            to_columns=["topic_id"],
        )
    ),

    source.GMMQSource(
        endpoint=DBMWEndPoints.TOPIC_TRIGGER,
    )
)
index_data_source = source.MySQLTableSource(
    logical_database_id=settings.MIMAS_LOGICAL_DATABASE_ID,
    table_name="api_problem",
    key_columns=['id'],
    value_columns_excluded=[],
    value_columns_all=True,
)
