# coding=utf-8
from django.conf import settings
from gm_dbmw_api.descriptor import source, relation

pk_data_source = source.GroupedSource.of(
    source.MySQLTableSource(
        logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
        table_name="auth_user",
        key_columns=['id'],
        value_columns_excluded=[],
        value_columns_all=True,
    ),
    source.RelatedSource(
        source=source.MySQLTableSource(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_userextra",
            key_columns=['id'],
            value_columns_excluded=[],
            value_columns_all=True,
        ),
        relation=relation.MySQLTableRelation(
            logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
            table_name="api_userextra",
            from_columns=["id"],
            to_columns=["user_id"],
        )
    )
)
index_data_source = source.MySQLTableSource(
    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
    table_name="auth_user",
    key_columns=['id'],
    value_columns_excluded=[],
    value_columns_all=True,
)
