# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import

from ..core.model_event import ModelDataMonitor, EventHandler
from ..core.django_data import DjangoDataSourceManager
from utils.data_sync.exposed_interface import monitored_model_list


class NullEventHandler(EventHandler):
    def handle_event(self, event):
        pass


mdm = ModelDataMonitor(NullEventHandler)
ddsm = DjangoDataSourceManager()

for m in monitored_model_list:
    mdm.add_model(m)
    ddsm.add_model(m)

for m in monitored_model_list:

    model_info = mdm.get_model_manager().model_modelinfo_map[m]
    for fi in model_info.foreign_fieldinfo_list:
        if fi.field.related.model not in mdm.get_model_manager().model_set:
            continue
        ddsm.add_foreign_key(fi.field)

    for m2mfi in model_info.many_to_many_fieldinfo_list:
        if m2mfi.field.related.model not in mdm.get_model_manager().model_set:
            continue
        ddsm.add_m2m_field(m2mfi.field)
