# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import

from utils.data_sync.exposed_interface import (
    current_time,
    parse_table_event,
)


__redis_connection = None


def get_redis_connection():
    global __redis_connection
    if __redis_connection is None:
        from utils.data_sync.exposed_interface import REDIS_SERVER_URL
        import redis
        __redis_connection = redis.StrictRedis.from_url(REDIS_SERVER_URL)
    return __redis_connection

