import os

from gm_dbmw_api.descriptor.connection import Connection, _TaskGroupCategory
from gm_dbmw_api.descriptor import descriptor_to_json


class ConnectionCreaterBase(object):
    def __init__(self, conn_name, base_dir, queue_name):
        self.conn_name = conn_name
        self.base_dir = base_dir
        self.queue_name = queue_name

    def online_connection(self):
        pass

    def round_connection(self):
        pass

    def full_connection(self):
        pass

    def save(self):
        """

        :return:
        """
        connections = {
            'online': self.online_connection(),
            'round-scanning': self.round_connection(),
            'full-scanning': self.full_connection(),
        }

        for dirname, connection in connections.items():
            if connection is None: continue

            assert isinstance(connection, Connection)
            with open(os.path.join(self.base_dir, dirname, "%s.json" % self.conn_name), 'w') as f:
                f.write(descriptor_to_json(connection))
