# coding=utf-8
from gm_types.gaia import SERVICE_FLAG

from lasker.models import Lasker, Award
from django.core.management import BaseCommand

AWARDS = [
    {
        "name": "最佳口碑整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/dbe8e02fda',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/ed4c20d4cf',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳服务理念整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/d2112f7779',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/fbdb4f2bd2',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最具人气医生",
        'image': 'https://heras.igengmei.com/2018/10/26/4d0400b343',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/87ad60e941',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最强造星能力医生",
        'image': 'https://heras.igengmei.com/2018/10/26/6bdf15fc61',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/ea587b73e7',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳审美医生",
        'image': 'https://heras.igengmei.com/2018/10/26/e264c4a6f6',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/9287d16a23',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳眼部整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/cefda95d12',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/53c9a49560',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳鼻部整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/512cfd4923',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/032aeb0048',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳胸部整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/44b2409d25',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/638b911dd1',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳颌面整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/06db10ec79',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/1c69fff16a',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳脂肪管理整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/c77d2d88c8',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/94cfa3aa73',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳唇部整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/ecc0185e0d',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/6d0f3b25ef',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳皮肤管理整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/ae701b884b',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/b208a06cd7',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳齿科美容整形医生",
        'image': 'https://heras.igengmei.com/2018/10/26/fed7215ecd',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/15a23761e6',
        'laureate_type': SERVICE_FLAG.DOCTOR
    },
    {
        "name": "最佳口碑整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/dbe8e02fda',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/ed4c20d4cf',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳服务理念整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/d2112f7779',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/fbdb4f2bd2',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最具人气整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/4d0400b343',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/87ad60e941',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最强造星能力整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/6bdf15fc61',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/ea587b73e7',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳审美整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/e264c4a6f6',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/9287d16a23',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳眼部整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/cefda95d12',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/53c9a49560',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳鼻部整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/512cfd4923',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/032aeb0048',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳胸部整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/44b2409d25',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/638b911dd1',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳骨骼美容机构",
        'image': 'https://heras.igengmei.com/2018/10/29/bc2bd69fb8',
        'image_styled': 'https://heras.igengmei.com/2018/10/29/c59dc01c97',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳脂肪管理整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/c77d2d88c8',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/94cfa3aa73',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳面部轮廓整形机构",
        'image': 'https://heras.igengmei.com/2018/10/29/96de4a7318',
        'image_styled': 'https://heras.igengmei.com/2018/10/29/de4b64183f',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳皮肤管理整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/ae701b884b',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/b208a06cd7',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
    {
        "name": "最佳齿科美容整形机构",
        'image': 'https://heras.igengmei.com/2018/10/26/fed7215ecd',
        'image_styled': 'https://heras.igengmei.com/2018/10/26/15a23761e6',
        'laureate_type': SERVICE_FLAG.HOSPITAL
    },
]


class Command(BaseCommand):

    def add_arguments(self, parser):
        pass

    def handle(self, *args, **options):
        lasker, created = Lasker.objects.get_or_create(year=2018, defaults={'name': u"金刀奖"})
        for award in AWARDS:
            Award.objects.update_or_create(lasker=lasker, name=award['name'], defaults={
                'image': award['image'],
                'image_styled': award['image_styled'],
                'laureate_type': award['laureate_type'],
            })
