# coding=utf-8
from django.db import models
from gm_types.gaia import MAIDAN_REVIEW_STATUS

from api.models import Doctor


class MaidanSetting(models.Model):
    class Meta:
        verbose_name = u'买单设置'
        verbose_name_plural = u'买单设置'
        db_table = u'maidan_setting'
        app_label = u'maidan'

    doctor = models.OneToOneField(Doctor, verbose_name=u'关联医生', related_name='maidansetting')
    is_open = models.BooleanField(verbose_name=u'是否开通', default=True)
    doctor_discount_rate = models.IntegerField(verbose_name=u'医生设置折扣比例', default=100)
    discount_rate = models.IntegerField(verbose_name=u'抽成比例', default=10)
    gengmei_offers_rate = models.IntegerField(verbose_name=u'更美承担优惠比例', default=1)


class MaidanSettingApply(models.Model):
    class Meta:
        verbose_name = u'买单设置申请'
        verbose_name_plural = u'买单设置申请'
        db_table = u'maidan_settingapply'
        app_label = u'maidan'

    doctor = models.OneToOneField(Doctor, verbose_name=u'关联医生', related_name='maidansettingapply')
    is_open = models.BooleanField(verbose_name=u'是否开通', default=True)
    doctor_discount_rate = models.IntegerField(verbose_name=u'医生设置折扣比例', default=100)
    status = models.CharField(choices=MAIDAN_REVIEW_STATUS, verbose_name=u'审核状态',
                              default=MAIDAN_REVIEW_STATUS.PASS, max_length=2)
    last_modify_time = models.DateTimeField(verbose_name=u'最后申请时间', null=True, blank=True, auto_created=True)
    last_review_time = models.DateTimeField(verbose_name=u'最近审核时间', null=True, blank=True)
