#! -*- coding: utf8 -*-
from __future__ import unicode_literals, absolute_import, print_function

from celery import shared_task

from rpc.context import get_rpc_remote_invoker
from rpc.tool.log_tool import logging_exception


@shared_task
def post_to_mima(event_type, trigger_time, user_id, item_id=None, pre_payment=None):
    rpc_invoker = get_rpc_remote_invoker()
    result = rpc_invoker['mimas/user/push_event'](
        event_type=event_type,
        item_id=item_id,
        trigger_time=trigger_time,
        user_id=user_id,
        pre_payment=pre_payment
    ).unwrap()
    return result


@shared_task
def send_event_task(event_type, user_id, related_item=None, only_record_event=False):
    result = {'growth_value': 0, 'point_value': 0, 'submit_count': 0}
    try:
        rpc_invoker = get_rpc_remote_invoker()
        result = rpc_invoker['mimas/user/process_event_task'](
            event_type=event_type,
            user_id=user_id,
            related_item=related_item,
            only_record_event=only_record_event
        ).unwrap()
    except:
        logging_exception()

    return result
