# coding=utf-8
from __future__ import unicode_literals, absolute_import

import json
import datetime
from xml.etree import ElementTree

from rpc.tool.error_code import gen
from rpc.tool.error_code import CODES
from api.models import Order
from api.models import ORDER_STATUS

from django.db import models

__all__ = ['ApplePayRefundManager']


class ApplePayRefundManager(models.Manager):
    def create_record(self, no_order, trade_data):
        print 'manager_trade_data\n\n', trade_data
        trade_data['money_refund'] = '1.00'
        self.create(
                order_no=no_order,
                oid_partner=trade_data['oid_partner'],
                oid_refundno=trade_data['oid_refundno'],
                money_refund=float(trade_data['money_refund']),
                no_refund=trade_data['no_refund'],
                dt_refund=datetime.datetime.strptime(trade_data['dt_refund'], "%Y%m%d%H%M%S"),
                sta_refund=trade_data['sta_refund'],
                settle_date=datetime.datetime.strptime(trade_data['settle_date'], "%Y%m%d"),
        )
