# coding=utf-8
from __future__ import unicode_literals, absolute_import

__all__ = ['StatementManager']

from django.db import models
from django.db import transaction
from rpc.tool.generate_random_code import generate_num
from api.models import User


class StatementManager(models.Manager):
    def create(self, doctor, statement_date):
        with transaction.atomic():
            statement = super(StatementManager, self).create(
                    id=generate_num(15),
                    doctor=doctor,
                    statement_date=int(statement_date),
            )
            from pay.models.operation import CreateOp
            operator = User.objects.get(pk=22).person
            op = CreateOp(statement=statement, operator=operator)
            op.do()
            return statement


class HistoryStatementManager(models.Manager):
    def get_queryset(self):
        return super(HistoryStatementManager, self).get_queryset().filter(statement_date__lte=201710)


class MaiDanHistoryStatementManager(models.Manager):
    def get_queryset(self):
        return super(MaiDanHistoryStatementManager, self).get_queryset().filter(statement_date__lte=201710)
