#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   zhangxiaolin
#   E-mail  :   petelin1120@gmail.com
#   Date    :   17/9/25 16:02
#   Desc    :   支付单

from django.db import models
from gm_types.pay import CHANNEL

from api.models import Settlement, Order
from pay.manager.payment_order_manager import PaymentManager


class PaymentOrder(models.Model):
    class Meta:
        verbose_name = u'美购支付信息'
        db_table = u'pay_paymentorder'
        app_label = u'pay'

    orders = models.ManyToManyField(Order, through='PaymentOrderItem', related_name='payment_orders')

    total_fee = models.IntegerField(verbose_name=u'实际付款额, 分')
    # 支付成功后更改
    third_user_account = models.CharField(null=True, max_length=100, verbose_name='三方支付平台用户账号(微信为openid, 支付宝是email)')
    channel = models.CharField(max_length=10, choices=CHANNEL, null=True, verbose_name=u'支付渠道')
    out_trade_no = models.CharField(max_length=32, null=True, verbose_name=u'商户的订单号')
    transaction_id = models.CharField(unique=True, max_length=50, null=True, verbose_name=u'第三方支付平台id')
    pay_start_time = models.DateTimeField(null=True, verbose_name=u'支付开始时间(第三方商户收到prepay创建订单的时间)')
    paid_time = models.DateTimeField(null=True, verbose_name=u'付款完成时间')
    notify_data = models.TextField(null=True, verbose_name=u'支付通知信息(json)')
    # 账号相关, 因为退款需要知道账号信息. 退款也迁移过去就不需要了.
    account_seller_id = models.CharField(verbose_name='商户id', max_length=100)

    create_at = models.DateTimeField(auto_now_add=True, verbose_name=u"这记录创建时间")

    objects = PaymentManager()


class PaymentOrderItem(models.Model):
    class Meta:
        verbose_name = u'美购支付信息--关联order'
        db_table = u'pay_paymentorderitem'
        app_label = u'pay'

    payment_order = models.ForeignKey(PaymentOrder, related_name='items')
    order = models.OneToOneField(Order, related_name='order_payment')


class PrepayTemp(models.Model):
    class Meta:
        verbose_name = u'迁移美购prepay的中间表用来区分是旧的prepay还是新的'
        db_table = u'pay_prepaytemp'
        app_label = u'pay'

    settlement = models.ForeignKey(Settlement)
    through_cadus = models.BooleanField(default=False)
