# coding=utf-8
import datetime
from celery import shared_task
from pay.tool.support_tool import send_email
from django.conf import settings
from django.db.models import Q
from api.models import RefundOrder
from api.models import Service
from api.models.types import REFUND_STATUS


@shared_task
def stock_alert(service_id, service_name, current_stock, email):
    to_email_list = [email] + settings.PAY_EMAIL_STOCK_ALTER_LIST
    from_email = settings.PAY_EMAIL_USER
    subject = u'美购[{service_id}]库存预报警'.format(service_id=service_id)
    body = u'美购ID: {service_id} \n美购名称: {service_name} \n当前库存为: {current_stock} \n请相关同事跟进'.format(
        service_id=service_id,
        service_name=service_name,
        current_stock=current_stock
    )
    return send_email(
        from_email=from_email,
        to_email_list=to_email_list,
        subject=subject,
        body=body
    )


@shared_task
def refund_alert(refund_order_id):
    # PAY_GATEWAY_TIMEOUT 一段时间后状态仍是医生同意,仲裁同意 则报错
    refund_order = RefundOrder.objects.get(pk=refund_order_id)

    if refund_order.status not in [REFUND_STATUS.ARBIT_APPROVE, REFUND_STATUS.DOCTOR_APPROVE]:
        return

    if refund_order.stale == True:
        return

    from_email = settings.PAY_EMAIL_USER
    to_email_list = settings.PAY_EMAIL_REFUND_ALERT_LIST
    subject = u'退款单[{refund_order_id}]状态错误'.format(refund_order_id=refund_order_id)
    body = u'当前状态处于 {refund_order_status}'.format(refund_order_status=refund_order.status)
    body += u'''
    \n
    状态数字代表的意义:
    (0, "PROCESSING", u"处理中")
    (1, "DOCTOR_REJECT", u"医生拒绝")
    (2, "ARBITING", u"等待仲裁")
    (3, "ARBIT_APPROVE", u"仲裁同意")
    (4, "ARBIT_REJECT", u'仲裁拒绝')
    (5, "REFUNDED", u"退款完成")
    (6, "CANCLED", u"已取消")
    (7, "REFUND_APPLY_SELLER_TIMEOUT", u"用户申请退款,商户决策超时")
    (8, "DOCTOR_APPROVE", u"商户主动同意退款")
    (9, "REFUNDING", u"已经开始进入第三方退款流程")  # 一旦进入此状态后, 此订单不可以再被退款or返现
    '''
    return send_email(
        from_email=from_email,
        to_email_list=to_email_list,
        subject=subject,
        body=body
    )


@shared_task
def remind_coupon_expire_alert(user_id=None):
    from_email = settings.PAY_EMAIL_USER
    to_email_list = ['yangchuncheng@gmei.com', 'lini@gmei.com']
    if user_id:
        subject = u'[{user_id}]美券过期提醒正在运行'.format(user_id=user_id)
    else:
        subject = u'美券过期提醒已运行完'
    body = ''
    return send_email(
        from_email=from_email,
        to_email_list=to_email_list,
        subject=subject,
        body=body
    )


@shared_task
def period_stock_alert():
    now = datetime.datetime.now()
    # query = Q(start_time__gt=now) | Q(end_time__lt=now) | Q(sell_num_limit__lte=0)
    # services = Service.objects.filter(is_online=True).filter(query)
    # body = ''
    # for service in services:
    #     one_body = u'美购ID: {service_id} \n美购名称: {service_name} \n当前库存为: {current_stock} \n请相关同事跟进\n\n\n'.format(
    #         service_id=service.id,
    #         service_name=service.name,
    #         current_stock=service.sell_num_limit
    #     )
    #     body += one_body
    # from_email = settings.PAY_EMAIL_USER
    # subject = '开团提醒库存报警'
    # return send_email(
    #         from_email=from_email,
    #         to_email_list=settings.PAY_EMAIL_KAITUAN_ALTER_LIST,
    #         subject=subject,
    #         body=body
    # )
